/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8273;

import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm8273.eui.TrapControlBasePanel;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class TrapControlPanel
extends TrapControlBasePanel {
    private TrapContainer trapContainer;
    private static String HelpDirName = "ibm.nways.jdm8273";
    private static String HelpDocName = "ibm.nways.jdm8273.TrapControlPanel.html";
    private HelpRef helpRef = new HelpRef(HelpDirName, HelpDocName);
    private static String bundleName = "ibm.nways.jdm8273.Rs8273Resources";

    private static int TrapSection_General() {
        return 1;
    }

    private static int TrapSection_VLAN() {
        return 2;
    }

    private static int TrapSection_Port() {
        return 3;
    }

    private static int TrapSection_ATM() {
        return 4;
    }

    private static int TrapSection_FrameRelay() {
        return 5;
    }

    private static int TrapSection_Generic() {
        return 6;
    }

    private static int TrapSection_Bridge() {
        return 7;
    }

    private static int TrapSection_RMON() {
        return 8;
    }

    private static int TrapSection_Chassis() {
        return 9;
    }

    private ModelInfo getNmsInfoInfo() {
        return this.NmsInfoInfo;
    }

    private TrapContainer getTrapContainer() {
        return this.trapContainer;
    }

    private static String getBundleName() {
        return bundleName;
    }

    public TrapControlPanel() {
        this.setHelpRef(this.helpRef);
        this.trapContainer = new TrapContainer();
    }

    protected void addGeneralTrapsCfgSection() {
        this.GeneralTrapsCfgPropertySection = new GeneralTrapsSection();
        this.GeneralTrapsCfgPropertySection.layoutSection();
        this.addSection(TrapControlBasePanel.getNLSString("GeneralTrapsCfgSectionTitle"), this.GeneralTrapsCfgPropertySection);
    }

    protected void addChassisTrapsCfgSection() {
        this.ChassisTrapsCfgPropertySection = new ChassisTrapsSection();
        this.ChassisTrapsCfgPropertySection.layoutSection();
        this.addSection(TrapControlBasePanel.getNLSString("ChassisTrapsCfgSectionTitle"), this.ChassisTrapsCfgPropertySection);
    }

    protected void addVlanTrapsCfgSection() {
        this.VlanTrapsCfgPropertySection = new VlanTrapsSection();
        this.VlanTrapsCfgPropertySection.layoutSection();
        this.addSection(TrapControlBasePanel.getNLSString("VlanTrapsCfgSectionTitle"), this.VlanTrapsCfgPropertySection);
    }

    protected void addPortTrapsCfgSection() {
        this.PortTrapsCfgPropertySection = new PortTrapsSection();
        this.PortTrapsCfgPropertySection.layoutSection();
        this.addSection(TrapControlBasePanel.getNLSString("PortTrapsCfgSectionTitle"), this.PortTrapsCfgPropertySection);
    }

    protected void addAtmTrapsCfgSection() {
        this.AtmTrapsCfgPropertySection = new AtmTrapsSection();
        this.AtmTrapsCfgPropertySection.layoutSection();
        this.addSection(TrapControlBasePanel.getNLSString("AtmTrapsCfgSectionTitle"), this.AtmTrapsCfgPropertySection);
    }

    protected void addFrRelayTrapsCfgSection() {
        this.FrRelayTrapsCfgPropertySection = new FrRelayTrapsSection();
        this.FrRelayTrapsCfgPropertySection.layoutSection();
        this.addSection(TrapControlBasePanel.getNLSString("FrRelayTrapsCfgSectionTitle"), this.FrRelayTrapsCfgPropertySection);
    }

    protected void addGenericTrapsCfgSection() {
        this.GenericTrapsCfgPropertySection = new GenericTrapsSection();
        this.GenericTrapsCfgPropertySection.layoutSection();
        this.addSection(TrapControlBasePanel.getNLSString("GenericTrapsCfgSectionTitle"), this.GenericTrapsCfgPropertySection);
    }

    protected void addBridgeTrapsCfgSection() {
        this.BridgeTrapsCfgPropertySection = new BridgeTrapsSection();
        this.BridgeTrapsCfgPropertySection.layoutSection();
        this.addSection(TrapControlBasePanel.getNLSString("BridgeTrapsCfgSectionTitle"), this.BridgeTrapsCfgPropertySection);
    }

    protected void addRmonTrapsCfgSection() {
        this.RmonTrapsCfgPropertySection = new RmonTrapsSection();
        this.RmonTrapsCfgPropertySection.layoutSection();
        this.addSection(TrapControlBasePanel.getNLSString("RmonTrapsCfgSectionTitle"), this.RmonTrapsCfgPropertySection);
    }

    static String TrapText_AllTraps() {
        return "AllTraps";
    }

    static String TrapText_GenericColdStart() {
        return "GenericColdStart";
    }

    static String TrapText_GenericWarmStart() {
        return "GenericWarmStart";
    }

    static String TrapText_GenericeLinkDown() {
        return "GenericLinkDown";
    }

    static String TrapText_GenericLinkUp() {
        return "GenericLinkUp";
    }

    static String TrapText_GenericAuthFailure() {
        return "AuthenticationFailure";
    }

    static String TrapText_GenericNeighborLoss() {
        return "NeighborLoss";
    }

    static String TrapText_BridgeNewRoot() {
        return "BridgeNewRoot";
    }

    static String TrapText_BridgeTopologyChange() {
        return "BridgeTopologyChange";
    }

    static String TrapText_RmonRisingAlarm() {
        return "RMONRisingAlarm";
    }

    static String TrapText_RmonFallingAlarm() {
        return "RMONFallingAlarm";
    }

    static String TrapText_SystemAdminAccessControl() {
        return "SystemAdminAccessControl";
    }

    static String TrapText_GlobalEnableControl() {
        return "GlobalEnableControl";
    }

    static String TrapText_Temperatrue() {
        return "TemperatureAlarm";
    }

    static String TrapText_ModuleChange() {
        return "ModuleChange";
    }

    static String TrapText_PowerEvent() {
        return "PowerEvent";
    }

    static String TrapText_ControllerEvent() {
        return "ControllerEvent";
    }

    static String TrapText_LoginViolation() {
        return "LoginViolation";
    }

    static String TrapText_MACvlanViolation() {
        return "VLANViolation";
    }

    static String TrapText_MACdupPort() {
        return "DuplicateMACAddress";
    }

    static String TrapText_PortLinkUp() {
        return "PortLinkUp";
    }

    static String TrapText_PortLinkDown() {
        return "PortLinkDown";
    }

    static String TrapText_PortPartitioned() {
        return "PortPartitioned";
    }

    static String TrapText_PortRecordMismatch() {
        return "PortChange";
    }

    static String TrapText_GroupChange() {
        return "GroupChange";
    }

    static String TrapText_VLAN_Change() {
        return "VLANChange";
    }

    static String TrapText_PortMove() {
        return "PortMove";
    }

    static String TrapText_ModuleResetReload() {
        return "ModuleReset";
    }

    static String TrapText_SystemEvent() {
        return "SystemEvent";
    }

    static String TrapText_VlanRouteTableFull() {
        return "RouteTableFull";
    }

    static String TrapText_SAPtableFull() {
        return "SAPTableFull";
    }

    static String TrapText_AtmSSCOPstate() {
        return "SSCOPChange";
    }

    static String TrapText_IlmiState() {
        return "ILMIChange";
    }

    static String TrapText_AtmConnection() {
        return "AtmConnectionChange";
    }

    static String TrapText_AtmService() {
        return "AtmServiceChange";
    }

    static String TrapText_FrRelayDlciCreated() {
        return "FrRelayDlciCreated";
    }

    static String TrapText_FrRelayDlciDeleted() {
        return "FrRelayDlciDeleted";
    }

    static String TrapText_FrRelayDlciActive() {
        return "FrRelayDlciActive";
    }

    static String TrapText_FrRelayDlciInactive() {
        return "FrRelayDlciInactive";
    }

    static String TrapText_PortManualForwarding() {
        return "PortManualForwarding";
    }

    final /* synthetic */ TrapContainer access$0() {
        return this.getTrapContainer();
    }

    static final /* synthetic */ String access$9() {
        return TrapControlPanel.getBundleName();
    }

    final /* synthetic */ ModelInfo access$11() {
        return this.getNmsInfoInfo();
    }

    private class GeneralTrapsSection
    extends TrapControlBasePanel.GeneralTrapsCfgSection {
        public GeneralTrapsSection() {
            TrapControlPanel.this = TrapControlPanel.this;
            Vector vector = TrapControlPanel.this.access$0().getSectionTraps(TrapControlPanel.TrapSection_General());
            this.setLayout(new GridLayout(vector.size() / 2 + 1, 2));
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                TrapObject trapObject = (TrapObject)enumeration.nextElement();
                this.add(trapObject.widget);
            }
        }

        protected Component createstationTrapFlagsField() {
            return null;
        }

        protected Serializable getstationTrapFlagsField() {
            OctetString octetString = TrapControlPanel.this.access$0().encodeFlags();
            return octetString;
        }

        protected void setstationTrapFlagsField(Object object) {
            if (object instanceof OctetString && TrapControlPanel.this.access$0() != null) {
                TrapControlPanel.this.access$0().setFromEncodedFlags((OctetString)object);
            }
        }

        protected boolean validatestationTrapFlagsField() {
            return true;
        }

        public void apply() {
            TrapControlPanel.this.access$11().add("NmsInfo.StationTrapFlags", this.getstationTrapFlagsField());
        }
    }

    private class ChassisTrapsSection
    extends TrapControlBasePanel.ChassisTrapsCfgSection {
        public ChassisTrapsSection() {
            TrapControlPanel.this = TrapControlPanel.this;
            Vector vector = TrapControlPanel.this.access$0().getSectionTraps(TrapControlPanel.TrapSection_Chassis());
            this.setLayout(new GridLayout(vector.size() / 2 + 1, 2));
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                TrapObject trapObject = (TrapObject)enumeration.nextElement();
                this.add(trapObject.widget);
            }
        }

        public void apply() {
        }

        public void reset() {
            this.doLayout();
        }
    }

    private class VlanTrapsSection
    extends TrapControlBasePanel.VlanTrapsCfgSection {
        public VlanTrapsSection() {
            TrapControlPanel.this = TrapControlPanel.this;
            Vector vector = TrapControlPanel.this.access$0().getSectionTraps(TrapControlPanel.TrapSection_VLAN());
            this.setLayout(new GridLayout(vector.size() / 2 + 1, 2));
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                TrapObject trapObject = (TrapObject)enumeration.nextElement();
                this.add(trapObject.widget);
            }
        }

        public void apply() {
        }

        public void reset() {
            this.doLayout();
        }
    }

    private class PortTrapsSection
    extends TrapControlBasePanel.PortTrapsCfgSection {
        public PortTrapsSection() {
            TrapControlPanel.this = TrapControlPanel.this;
            Vector vector = TrapControlPanel.this.access$0().getSectionTraps(TrapControlPanel.TrapSection_Port());
            this.setLayout(new GridLayout(vector.size() / 2 + 1, 2));
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                TrapObject trapObject = (TrapObject)enumeration.nextElement();
                this.add(trapObject.widget);
            }
        }

        public void apply() {
        }

        public void reset() {
            this.doLayout();
        }
    }

    private class AtmTrapsSection
    extends TrapControlBasePanel.AtmTrapsCfgSection {
        public AtmTrapsSection() {
            TrapControlPanel.this = TrapControlPanel.this;
            Vector vector = TrapControlPanel.this.access$0().getSectionTraps(TrapControlPanel.TrapSection_ATM());
            this.setLayout(new GridLayout(vector.size() / 2 + 1, 2));
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                TrapObject trapObject = (TrapObject)enumeration.nextElement();
                this.add(trapObject.widget);
            }
        }

        public void apply() {
        }

        public void reset() {
            this.doLayout();
        }
    }

    private class FrRelayTrapsSection
    extends TrapControlBasePanel.FrRelayTrapsCfgSection {
        public FrRelayTrapsSection() {
            TrapControlPanel.this = TrapControlPanel.this;
            Vector vector = TrapControlPanel.this.access$0().getSectionTraps(TrapControlPanel.TrapSection_FrameRelay());
            this.setLayout(new GridLayout(vector.size() / 2 + 1, 2));
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                TrapObject trapObject = (TrapObject)enumeration.nextElement();
                this.add(trapObject.widget);
            }
        }

        public void apply() {
        }

        public void reset() {
            this.doLayout();
        }
    }

    private class GenericTrapsSection
    extends TrapControlBasePanel.GenericTrapsCfgSection {
        public GenericTrapsSection() {
            TrapControlPanel.this = TrapControlPanel.this;
            Vector vector = TrapControlPanel.this.access$0().getSectionTraps(TrapControlPanel.TrapSection_Generic());
            this.setLayout(new GridLayout(vector.size() / 2 + 1, 2));
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                TrapObject trapObject = (TrapObject)enumeration.nextElement();
                this.add(trapObject.widget);
            }
        }

        public void apply() {
        }

        public void reset() {
            this.doLayout();
        }
    }

    private class BridgeTrapsSection
    extends TrapControlBasePanel.BridgeTrapsCfgSection {
        public BridgeTrapsSection() {
            TrapControlPanel.this = TrapControlPanel.this;
            Vector vector = TrapControlPanel.this.access$0().getSectionTraps(TrapControlPanel.TrapSection_Bridge());
            this.setLayout(new GridLayout(vector.size() / 2 + 1, 2));
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                TrapObject trapObject = (TrapObject)enumeration.nextElement();
                this.add(trapObject.widget);
            }
        }

        public void apply() {
        }

        public void reset() {
            this.doLayout();
        }
    }

    private class RmonTrapsSection
    extends TrapControlBasePanel.RmonTrapsCfgSection {
        public RmonTrapsSection() {
            TrapControlPanel.this = TrapControlPanel.this;
            Vector vector = TrapControlPanel.this.access$0().getSectionTraps(TrapControlPanel.TrapSection_RMON());
            this.setLayout(new GridLayout(vector.size() / 2 + 1, 2));
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                TrapObject trapObject = (TrapObject)enumeration.nextElement();
                this.add(trapObject.widget);
            }
        }

        public void apply() {
        }

        public void reset() {
            this.doLayout();
        }
    }

    private class TrapContainer {
        ResourceBundle myResources = ResourceBundle.getBundle(TrapControlPanel.access$9());
        private Vector trapList = new Vector();

        TrapContainer() {
            TrapControlPanel.this = TrapControlPanel.this;
            TrapControlPanel trapControlPanel2 = TrapControlPanel.this;
            trapControlPanel2.getClass();
            TrapObject trapObject = trapControlPanel2.new TrapObject(this, TrapControlPanel.TrapText_AllTraps(), "FFFFFFFFFFFFFFFF", TrapControlPanel.TrapSection_General());
            trapObject.setAllTrapsFlag(true);
            this.trapList.addElement(trapObject);
            TrapControlPanel trapControlPanel3 = TrapControlPanel.this;
            trapControlPanel3.getClass();
            this.trapList.addElement(trapControlPanel3.new TrapObject(this, TrapControlPanel.TrapText_GenericColdStart(), "0000000100000000", TrapControlPanel.TrapSection_Generic()));
            TrapControlPanel trapControlPanel4 = TrapControlPanel.this;
            trapControlPanel4.getClass();
            this.trapList.addElement(trapControlPanel4.new TrapObject(this, TrapControlPanel.TrapText_GenericWarmStart(), "0000000200000000", TrapControlPanel.TrapSection_Generic()));
            TrapControlPanel trapControlPanel5 = TrapControlPanel.this;
            trapControlPanel5.getClass();
            this.trapList.addElement(trapControlPanel5.new TrapObject(this, TrapControlPanel.TrapText_GenericeLinkDown(), "0000000400000000", TrapControlPanel.TrapSection_Generic()));
            TrapControlPanel trapControlPanel6 = TrapControlPanel.this;
            trapControlPanel6.getClass();
            this.trapList.addElement(trapControlPanel6.new TrapObject(this, TrapControlPanel.TrapText_GenericLinkUp(), "0000000800000000", TrapControlPanel.TrapSection_Generic()));
            TrapControlPanel trapControlPanel7 = TrapControlPanel.this;
            trapControlPanel7.getClass();
            this.trapList.addElement(trapControlPanel7.new TrapObject(this, TrapControlPanel.TrapText_GenericAuthFailure(), "0000001000000000", TrapControlPanel.TrapSection_Generic()));
            TrapControlPanel trapControlPanel8 = TrapControlPanel.this;
            trapControlPanel8.getClass();
            this.trapList.addElement(trapControlPanel8.new TrapObject(this, TrapControlPanel.TrapText_GenericNeighborLoss(), "0000002000000000", TrapControlPanel.TrapSection_Generic()));
            TrapControlPanel trapControlPanel9 = TrapControlPanel.this;
            trapControlPanel9.getClass();
            this.trapList.addElement(trapControlPanel9.new TrapObject(this, TrapControlPanel.TrapText_BridgeNewRoot(), "0000040000000000", TrapControlPanel.TrapSection_Bridge()));
            TrapControlPanel trapControlPanel10 = TrapControlPanel.this;
            trapControlPanel10.getClass();
            this.trapList.addElement(trapControlPanel10.new TrapObject(this, TrapControlPanel.TrapText_BridgeTopologyChange(), "0000080000000000", TrapControlPanel.TrapSection_Bridge()));
            TrapControlPanel trapControlPanel11 = TrapControlPanel.this;
            trapControlPanel11.getClass();
            this.trapList.addElement(trapControlPanel11.new TrapObject(this, TrapControlPanel.TrapText_RmonRisingAlarm(), "0000400000000000", TrapControlPanel.TrapSection_RMON()));
            TrapControlPanel trapControlPanel12 = TrapControlPanel.this;
            trapControlPanel12.getClass();
            this.trapList.addElement(trapControlPanel12.new TrapObject(this, TrapControlPanel.TrapText_RmonFallingAlarm(), "0000800000000000", TrapControlPanel.TrapSection_RMON()));
            TrapControlPanel trapControlPanel13 = TrapControlPanel.this;
            trapControlPanel13.getClass();
            this.trapList.addElement(trapControlPanel13.new TrapObject(this, TrapControlPanel.TrapText_SystemAdminAccessControl(), "4000000000000000", TrapControlPanel.TrapSection_General()));
            TrapControlPanel trapControlPanel14 = TrapControlPanel.this;
            trapControlPanel14.getClass();
            this.trapList.addElement(trapControlPanel14.new TrapObject(this, TrapControlPanel.TrapText_GlobalEnableControl(), "8000000000000000", TrapControlPanel.TrapSection_General()));
            TrapControlPanel trapControlPanel15 = TrapControlPanel.this;
            trapControlPanel15.getClass();
            this.trapList.addElement(trapControlPanel15.new TrapObject(this, TrapControlPanel.TrapText_Temperatrue(), "0000000000000001", TrapControlPanel.TrapSection_Chassis()));
            TrapControlPanel trapControlPanel16 = TrapControlPanel.this;
            trapControlPanel16.getClass();
            this.trapList.addElement(trapControlPanel16.new TrapObject(this, TrapControlPanel.TrapText_ModuleChange(), "0000000000000002", TrapControlPanel.TrapSection_Chassis()));
            TrapControlPanel trapControlPanel17 = TrapControlPanel.this;
            trapControlPanel17.getClass();
            this.trapList.addElement(trapControlPanel17.new TrapObject(this, TrapControlPanel.TrapText_PowerEvent(), "0000000000000004", TrapControlPanel.TrapSection_Chassis()));
            TrapControlPanel trapControlPanel18 = TrapControlPanel.this;
            trapControlPanel18.getClass();
            this.trapList.addElement(trapControlPanel18.new TrapObject(this, TrapControlPanel.TrapText_ControllerEvent(), "0000000000000008", TrapControlPanel.TrapSection_Chassis()));
            TrapControlPanel trapControlPanel19 = TrapControlPanel.this;
            trapControlPanel19.getClass();
            this.trapList.addElement(trapControlPanel19.new TrapObject(this, TrapControlPanel.TrapText_LoginViolation(), "0000000000000010", TrapControlPanel.TrapSection_General()));
            TrapControlPanel trapControlPanel20 = TrapControlPanel.this;
            trapControlPanel20.getClass();
            this.trapList.addElement(trapControlPanel20.new TrapObject(this, TrapControlPanel.TrapText_MACvlanViolation(), "0000000000000020", TrapControlPanel.TrapSection_VLAN()));
            TrapControlPanel trapControlPanel21 = TrapControlPanel.this;
            trapControlPanel21.getClass();
            this.trapList.addElement(trapControlPanel21.new TrapObject(this, TrapControlPanel.TrapText_MACdupPort(), "0000000000000040", TrapControlPanel.TrapSection_Port()));
            TrapControlPanel trapControlPanel22 = TrapControlPanel.this;
            trapControlPanel22.getClass();
            this.trapList.addElement(trapControlPanel22.new TrapObject(this, TrapControlPanel.TrapText_PortLinkUp(), "0000000000000080", TrapControlPanel.TrapSection_Port()));
            TrapControlPanel trapControlPanel23 = TrapControlPanel.this;
            trapControlPanel23.getClass();
            this.trapList.addElement(trapControlPanel23.new TrapObject(this, TrapControlPanel.TrapText_PortLinkDown(), "0000000000000100", TrapControlPanel.TrapSection_Port()));
            TrapControlPanel trapControlPanel24 = TrapControlPanel.this;
            trapControlPanel24.getClass();
            this.trapList.addElement(trapControlPanel24.new TrapObject(this, TrapControlPanel.TrapText_PortPartitioned(), "0000000000000200", TrapControlPanel.TrapSection_Port()));
            TrapControlPanel trapControlPanel25 = TrapControlPanel.this;
            trapControlPanel25.getClass();
            this.trapList.addElement(trapControlPanel25.new TrapObject(this, TrapControlPanel.TrapText_PortRecordMismatch(), "0000000000000400", TrapControlPanel.TrapSection_Port()));
            TrapControlPanel trapControlPanel26 = TrapControlPanel.this;
            trapControlPanel26.getClass();
            this.trapList.addElement(trapControlPanel26.new TrapObject(this, TrapControlPanel.TrapText_GroupChange(), "0000000000002000", TrapControlPanel.TrapSection_VLAN()));
            TrapControlPanel trapControlPanel27 = TrapControlPanel.this;
            trapControlPanel27.getClass();
            this.trapList.addElement(trapControlPanel27.new TrapObject(this, TrapControlPanel.TrapText_VLAN_Change(), "0000000000004000", TrapControlPanel.TrapSection_VLAN()));
            TrapControlPanel trapControlPanel28 = TrapControlPanel.this;
            trapControlPanel28.getClass();
            this.trapList.addElement(trapControlPanel28.new TrapObject(this, TrapControlPanel.TrapText_PortMove(), "0000000000008000", TrapControlPanel.TrapSection_VLAN()));
            TrapControlPanel trapControlPanel29 = TrapControlPanel.this;
            trapControlPanel29.getClass();
            this.trapList.addElement(trapControlPanel29.new TrapObject(this, TrapControlPanel.TrapText_ModuleResetReload(), "0000000000010000", TrapControlPanel.TrapSection_Chassis()));
            TrapControlPanel trapControlPanel30 = TrapControlPanel.this;
            trapControlPanel30.getClass();
            this.trapList.addElement(trapControlPanel30.new TrapObject(this, TrapControlPanel.TrapText_SystemEvent(), "0000000000020000", TrapControlPanel.TrapSection_General()));
            TrapControlPanel trapControlPanel31 = TrapControlPanel.this;
            trapControlPanel31.getClass();
            this.trapList.addElement(trapControlPanel31.new TrapObject(this, TrapControlPanel.TrapText_VlanRouteTableFull(), "0000000000040000", TrapControlPanel.TrapSection_VLAN()));
            TrapControlPanel trapControlPanel32 = TrapControlPanel.this;
            trapControlPanel32.getClass();
            this.trapList.addElement(trapControlPanel32.new TrapObject(this, TrapControlPanel.TrapText_SAPtableFull(), "0000000000080000", TrapControlPanel.TrapSection_VLAN()));
            TrapControlPanel trapControlPanel33 = TrapControlPanel.this;
            trapControlPanel33.getClass();
            this.trapList.addElement(trapControlPanel33.new TrapObject(this, TrapControlPanel.TrapText_AtmSSCOPstate(), "0000000000100000", TrapControlPanel.TrapSection_ATM()));
            TrapControlPanel trapControlPanel34 = TrapControlPanel.this;
            trapControlPanel34.getClass();
            this.trapList.addElement(trapControlPanel34.new TrapObject(this, TrapControlPanel.TrapText_IlmiState(), "0000000000200000", TrapControlPanel.TrapSection_ATM()));
            TrapControlPanel trapControlPanel35 = TrapControlPanel.this;
            trapControlPanel35.getClass();
            this.trapList.addElement(trapControlPanel35.new TrapObject(this, TrapControlPanel.TrapText_AtmConnection(), "0000000000400000", TrapControlPanel.TrapSection_ATM()));
            TrapControlPanel trapControlPanel36 = TrapControlPanel.this;
            trapControlPanel36.getClass();
            this.trapList.addElement(trapControlPanel36.new TrapObject(this, TrapControlPanel.TrapText_AtmService(), "0000000000800000", TrapControlPanel.TrapSection_ATM()));
            TrapControlPanel trapControlPanel37 = TrapControlPanel.this;
            trapControlPanel37.getClass();
            this.trapList.addElement(trapControlPanel37.new TrapObject(this, TrapControlPanel.TrapText_FrRelayDlciCreated(), "0000000004000000", TrapControlPanel.TrapSection_FrameRelay()));
            TrapControlPanel trapControlPanel38 = TrapControlPanel.this;
            trapControlPanel38.getClass();
            this.trapList.addElement(trapControlPanel38.new TrapObject(this, TrapControlPanel.TrapText_FrRelayDlciDeleted(), "0000000008000000", TrapControlPanel.TrapSection_FrameRelay()));
            TrapControlPanel trapControlPanel39 = TrapControlPanel.this;
            trapControlPanel39.getClass();
            this.trapList.addElement(trapControlPanel39.new TrapObject(this, TrapControlPanel.TrapText_FrRelayDlciActive(), "0000000010000000", TrapControlPanel.TrapSection_FrameRelay()));
            TrapControlPanel trapControlPanel40 = TrapControlPanel.this;
            trapControlPanel40.getClass();
            this.trapList.addElement(trapControlPanel40.new TrapObject(this, TrapControlPanel.TrapText_PortManualForwarding(), "0000000040000000", TrapControlPanel.TrapSection_Port()));
        }

        void setFromEncodedFlags(OctetString octetString) {
            Enumeration enumeration = this.trapList.elements();
            while (enumeration.hasMoreElements()) {
                TrapObject trapObject = (TrapObject)enumeration.nextElement();
                trapObject.setFromEncodedFlags(octetString);
            }
        }

        OctetString encodeFlags() {
            OctetString octetString = new OctetString("00000000000000000000000000000000");
            Enumeration enumeration = this.trapList.elements();
            while (enumeration.hasMoreElements()) {
                TrapObject trapObject = (TrapObject)enumeration.nextElement();
                trapObject.encodeFlags(octetString);
            }
            return octetString;
        }

        String getNLSdescription(String string) {
            return this.myResources.getString(string);
        }

        Vector getAllTraps() {
            return this.trapList;
        }

        Vector getSectionTraps(int n) {
            Vector<TrapObject> vector = new Vector<TrapObject>();
            Enumeration enumeration = this.trapList.elements();
            while (enumeration.hasMoreElements()) {
                TrapObject trapObject = (TrapObject)enumeration.nextElement();
                if (trapObject.getSectionAssignment() != n) continue;
                vector.addElement(trapObject);
            }
            return vector;
        }
    }

    private class TrapObject {
        String description;
        boolean enabledFlag;
        boolean allTrapsFlag;
        String sBitmask;
        OctetString bitmask;
        Checkbox widget;
        int sectionAssignment;

        TrapObject(TrapContainer trapContainer, String string, String string2, int n) {
            TrapControlPanel.this = TrapControlPanel.this;
            this.description = trapContainer.getNLSdescription(string);
            this.sectionAssignment = n;
            this.allTrapsFlag = false;
            this.sBitmask = string2;
            this.bitmask = new OctetString(String.valueOf(string2) + "0000000000000000");
            this.enabledFlag = false;
            this.widget = new Checkbox(this.description, null, this.enabledFlag);
            this.widget.setBackground(JmaColors.background);
            this.widget.setForeground(JmaColors.textText);
        }

        String getDescription() {
            return this.description;
        }

        boolean getState() {
            if (this.widget != null) {
                this.enabledFlag = this.widget.getState();
            }
            return this.enabledFlag;
        }

        void setState(boolean bl) {
            this.enabledFlag = bl;
            if (this.widget != null) {
                this.widget.setState(this.enabledFlag);
            }
        }

        boolean getAllTrapsFlag() {
            return this.allTrapsFlag;
        }

        void setAllTrapsFlag(boolean bl) {
            this.allTrapsFlag = bl;
        }

        int getSectionAssignment() {
            return this.sectionAssignment;
        }

        void setWidget(Checkbox checkbox) {
            this.widget = checkbox;
            this.widget.setState(this.enabledFlag);
        }

        Checkbox getWidget() {
            return this.widget;
        }

        void setFromEncodedFlags(OctetString octetString) {
            if (this.bitmask.value.length == octetString.value.length) {
                boolean bl = true;
                int n = 0;
                while (n < this.bitmask.value.length) {
                    byte by = (byte)(octetString.value[n] & this.bitmask.value[n]);
                    if (by != this.bitmask.value[n]) {
                        bl = false;
                    }
                    ++n;
                }
                this.setState(bl);
                return;
            }
            System.err.println("Unexpected size of Trap Flags mib variable");
        }

        void encodeFlags(OctetString octetString) {
            if (this.bitmask.value.length == octetString.value.length) {
                if (this.getState()) {
                    int n = 0;
                    while (n < this.bitmask.value.length) {
                        octetString.value[n] = (byte)(octetString.value[n] | this.bitmask.value[n]);
                        ++n;
                    }
                    return;
                }
            } else {
                System.err.println("Unexpected size of Trap Flags mib variable");
            }
        }
    }
}

